<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Depotage extends Model 
{

    protected $table = 'depotages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('end_at', 'end_liquid_temperature', 'end_height', 'end_volume', 'start_height', 'start_liquid_temperature', 'start_volume', 'status', 'take_at', 'tank_id');
    protected $visible = array('end_at', 'end_liquid_temperature', 'end_height', 'end_volume', 'start_height', 'start_liquid_temperature', 'start_volume', 'status', 'take_at', 'tank_id');

    public function tank()
    {
        return $this->belongsTo('Tank', 'tank_id');
    }

}